/*------------------------------------------------------------------------------*
 * File Name: WaitCursor.c														*
 * Creation: GRD, 2002.06.29													*
 * Purpose: OriginC Source C file for Tutorial									*
 * Copyright (c) OriginLab Corp.	2002, 2003, 2004, 2005, 2006, 2007			*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
#include <origin.h>
////////////////////////////////////////////////////////////////////////////////////

// Set the Mouse Pointer to 'Busy' while long process continues
//After Build this sample, Please closed the CodeBuild and input "BusyAsABee" in scrip window,
//and enter, than you can press ESC to test this program. 
void BusyAsABee()
{
	// Create a Worksheet object from the active window
	Worksheet wks = Project.ActiveLayer();
	// If the active window is not a worksheet, create one from ORIGIN.OTW
	if(wks==NULL)
	{
		wks.Create("origin", CREATE_VISIBLE);
	}

	waitCursor	cur;        // waitCursor object
	string		str;        // String for messages
	int			nCol = 0;   // int holds number of columns added

	// Loop : 1000 times, but check for user pressing Escape key
	for(int ii = 0; ii < 1000 && !cur.CheckEsc(); ii++)
	{
		// Add a column to the worksheet
		wks.AddCol();
		// Type a message to the Data Display window and increment column count
		str.Format("Adding col %d", nCol++);
		SetDataDisplayText(str);
	}
	// Check if the loop completed normally, otherwise the user must have pressed
	// Escape key
	if(ii < 1000)
		printf("User aborted adding columns. %d columns were added.\n", nCol);
}